﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="POSOrdering.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.POS.POSOrdering" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:ScriptManager runat="server" ID="smDefault">
        <Services>
            <asp:ServiceReference Path="~/Admin/WebService/AzvicService.asmx" />
        </Services>
    </asp:ScriptManager>
    <asp:HiddenField ID="hdProductID" runat="server" />
    <div class="pageheader">
        <h2>
            <i class="fa fa-user"></i>Point Of Sale
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../Dashboard.aspx">Ei8ht POS</a></li>
                <li class="active">POS</li>
            </ol>
        </div>
    </div>
    <br class="visible-sm visible-md" />
    <div class="row visible-sm visible-md">
        <div class="col-sm-12 col-md-12">
            <input type="button" id="btnCategoryAll" value="All" onclick="ShowAll();" class="pos-menu-button" />
            <asp:Repeater runat="server" ID="rpCategories">
                <ItemTemplate>
                    <input type="button" id="btnCategory" value="<%# Eval("CategoryName")%>" onclick="LoadItems('<%# Eval("UniqueID") %>');" class="pos-menu-button" />
                </ItemTemplate>
            </asp:Repeater>
        </div>

    </div><br class="visible-sm visible-md" />
    <div class="row">

        <div id="divItems" class="col-md-6 col-sm-6 col-xs-6">
            <asp:Repeater runat="server" ID="rpProducts">
                <ItemTemplate>
                    <div class="pos-product">
                        <img src='<%#string.Format("/Images/ProductsImages/{0}",(string.IsNullOrEmpty(Eval("Image1").ToString()) ? "No-Image1.png":Eval("Image1"))) %>' data-category='<%#Eval("ProductCategoryID")%>' onclick='AddProduct("<%# Eval("UniqueID") %>")'
                            style="width: 100%; height: 100%;" />
                    </div>
                </ItemTemplate>
            </asp:Repeater>
        </div>
        <div id="divShoppingCart" class="col-md-6 col-sm-6 col-xs-6">
            <div class="row">
                <div class="col-md-4 col-xs-6 pull-left">
                    <h3 style="margin-top: 0px;" class="pos-highlightText">
                        <span id="lblNumberofItems"></span>
                        Item(s) <img id="imgloader" src="../Images/pos-loader.gif" /></h3>
                </div>
                <div class="col-md-8 col-xs-6 pull-right">
                    <div class="input-group">
                        <asp:TextBox runat="server" ID="txtSearch" CssClass="form-control pos-tablet" placeholder="Enter Barcode or Product Code" Style="min-width: 100px;"></asp:TextBox>
                        <span class="input-group-btn">
                            <asp:Button ID="Button1" Text="+" runat="server" CssClass="btn-primary btn" />
                        </span>
                    </div>
                    <!-- /input-group -->
                </div>
            </div>
            <br />
            <br />
            <div class="row">
                <div class="col-xs-12 col-md-12 pos-cart-scroll">
                    <table class="table" id="ShoppingCartTable">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Qty</th>
                                <th>Price</th>
                                <th>Total</th>
                                <th>Delete</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 col-xs-12 pull-left">
                    <select style="min-width: 100px; color: black;" id="ddlTax" onchange="UpdateShoppingCart();">
                        <option value="7" selected="selected">GST at 7%</option>
                        <option value="0">No Tax</option>
                    </select><br />
                    <br />
                    <asp:HyperLink runat="server" ID="btnDiscount" NavigateUrl="javascript:void(0);" Font-Underline="false" Text="Discount" CssClass="btn btn-default " Font-Size="18px" onclick="jQuery('#divDiscount').modal();" />
                    <br /><br />
                </div>
                <br class="visible-xs" />
                <br class="visible-xs" />
                <div class="col-md-8 col-xs-12 pull-right">
                    <table class="table">
                        <tr>
                            <td>
                                <h4>Sub Total</h4>
                            </td>
                            <td>
                                <h4>
                                    <span id="lblSubTotal"></span></h4>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h4>Discount</h4>
                            </td>
                            <td>
                                <h4>
                                    <span id="lblDiscount"></span></h4>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h4>Total Before GST</h4>
                            </td>
                            <td>
                                <h4>
                                    <span id="lblTotalBeforeGST"></span></h4>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h4>GST</h4>
                            </td>
                            <td>
                                <h4>
                                    <span id="lblGST"></span></h4>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h4>Total</h4>
                            </td>
                            <td>
                                <h4>
                                    <span id="lblTotal"></span></h4>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            <br />
            <br />
            <div class="row text-center">
                <asp:LinkButton ID="lnkPay" runat="server" OnClick="lnkPay_Click" Font-Underline="false" Font-Bold="true" Font-Size="18px" CssClass="btn btn-primary w90p btn-lg">
                    <span id="lblTotalPayment" />
                </asp:LinkButton>
            </div>
        </div>
    </div>

    <div class="modal fade" id="divPayment" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H1">Payment</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-xs-12 col-md-12">
                            <asp:Label ID="lblPayError" ForeColor="Red" runat="server" />
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-6">Pay Method : </div>
                        <div class="col-xs-12 col-md-6">
                            <asp:DropDownList ID="ddlPayMethod" runat="server" CssClass="listbox" Width="150px">
                                <asp:ListItem Selected="true" Value="0" Text="-- Please Select --" />
                                <asp:ListItem Value="Cash" Text="Cash" />
                                <asp:ListItem Value="Cheque" Text="Cheque" />
                                <asp:ListItem Value="Pending" Text="Pending" />
                            </asp:DropDownList>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-6">Amount :</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:Label runat="server" ID="lblPayTotal" CssClass="adminlabel" />
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-6">Paid Amount :</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:TextBox runat="server" ID="txtPaidAmount" CssClass="textbox number" MaxLength="10" Width="80px" />
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-6">Code / Bank Name:</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:TextBox runat="server" ID="txtBankName" CssClass="textbox" />
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-6">Cheque / Reference No.:</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:TextBox runat="server" ID="txtReferenceNo" CssClass="textbox" />
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="btnSaveOrder" runat="server" CssClass="btn btn-primary loading" Text="Save"
                        OnClick="btnSaveOrder_Click" />
                    <asp:Button ID="Button3" runat="server" CssClass="btn btn-danger loading" Text="Cancel" data-dismiss="modal" />

                </div>

            </div>
        </div>
    </div>

    <div class="modal fade" id="divProduct" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H2">Product</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-xs-12 col-md-12">
                            <asp:Label ID="lblPError" ForeColor="Red" runat="server" />
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-6">Qty</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:TextBox runat="server" ID="txtQty" CssClass="textbox number" MaxLength="6" Width="80px" />
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-6">Price</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:Label runat="server" ID="lblPrice" CssClass="textbox number" Width="80px" />
                        </div>
                    </div>

                    <div class="modal-footer">
                        <asp:Button ID="Button4" runat="server" CssClass="btn btn-primary loading" Text="Update"
                            OnClick="btnUpdateProduct_Click" />
                        &nbsp;
                                        <asp:Button ID="Button5" runat="server" CssClass="btn btn-primary loading" Text="Cancel" data-dismiss="modal" />

                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="divDiscount" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H3">Discount</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-xs-12 col-md-12">
                            <asp:Label ID="lblDiscountError" ForeColor="Red" runat="server" />
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-6">Discount Type:</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:DropDownList ID="ddlDiscountType" runat="server" CssClass="listbox" Width="150px">
                                <asp:ListItem Selected="true" Value="0" Text="-- Please Select --" />
                                <asp:ListItem Value="Dollar" Text="Dollar" />
                                <asp:ListItem Value="Percentage" Text="Percentage" />
                            </asp:DropDownList>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-6">Discount</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:TextBox runat="server" ID="txtDiscountValue" CssClass="textbox number" MaxLength="6" Width="80px" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <asp:Button ID="btnApplyDiscount" runat="server" CssClass="btn btn-primary loading" Text="Apply"
                            OnClick="btnApplyDiscount_Click" />
                        &nbsp;
                                        <asp:Button ID="btnDiscountCancel" runat="server" CssClass="btn btn-primary loading" Text="Cancel" data-dismiss="modal" />
                    </div>

                </div>
            </div>
        </div>
    </div>

    <%--Alert Popup--%>
    <div class="modal fade" id="divConfirmation" tabindex="-1" role="dialog" aria-labelledby="Confirm Deletion" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H4">Confirm Delete?</h4>
                </div>
                <div class="modal-body">
                    Are you sure want to delete the item from Shopping Cart?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="btnYes" onclick="ConfirmDelete();">Yes </button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">No </button>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
    <script>
        var CurrentProduct;
        var Tax;

        function parseFloat2(str) {
            var val1 = parseFloat(str).toFixed(2);
            val1 = '$ ' + val1;
            return val1;
        }
        function ShowAll(){
            $('#divItems div.pos-product').show();
        }

        function LoadItems(categoryID){
            $('#divItems div.pos-product img').each(function(){
                if($(this).attr('data-category')!=categoryID)
                {
                    $(this).parent('div.pos-product').hide();
                }
                else
                {
                    $(this).parent('div.pos-product').show();
                }
            });
        }
        $(window).resize(function(){
            $('#divItems').height($(window).height()*0.8);
            $('#divItems').css('overflow-y','scroll');
            $('div.pos-cart-scroll').css('max-height',$(window).height()*0.4);
        });

        $(document).ready(function () {
            $('#divItems').height($(window).height()*0.8);
            $('#divItems').css('overflow-y','scroll');
            $('div.pos-cart-scroll').css('max-height',$(window).height()*0.4);
            $('#imgloader').hide();
            $('#lblNumberofItems').text('0');
            AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.ReturnAllProducts(OnSuccess, OnFailure);
        });

        function OpenProduct(productID)
        {
            var ProductLink=$('#ShoppingCartTable a[data-prodid='+productID+']');
            $('#divProduct h4.modal-title').text($(ProductLink).text());
            $('#<%= txtQty.ClientID %>').val($(ProductLink).parent().siblings('td.pos-tblQty').text());
            $('#<%= lblPrice.ClientID %>').text($(ProductLink).parent().siblings('td.pos-tblPrice').text());
            $('#<%= hdProductID.ClientID %>').val(productID);
            $('#divProduct').modal('show');
        }

        function OnSuccess(result) {
            for (var i = 0; i < result.length; i++) {
                var NewRow = '<tr><td class="pos-tblName"><a class="anchor" onclick="OpenProduct(\'' + result[i].ProductID + '\')" data-prodid="' + result[i].ProductID + '">' + result[i].ProductName + '</a></td>'
                + '<td align="center" class="pos-tblQty">' + result[i].Quantity + '</td>' +
                '<td align="right" class="pos-tblPrice">' + parseFloat2(result[i].OrderPrice) + '</td>' +
                '<td align="right" class="pos-tblTotal">' + parseFloat2(result[i].Amount) + '</td>' +
                '<td align="center"><a class="fa fa-times-circle-o fa-2x" href="#" onclick="DeleteConfirmation(\'' + result[i].ProductID + '\');" /> </td></tr>';
                $('#ShoppingCartTable tbody').append(NewRow);
             
            }
            UpdateShoppingCart();
        }

        function AddProduct(productID) {
            $('#imgloader').show();
            $('#ShoppingCartTable tbody').find('td.pos-tblName a').each(function () {
                if ($(this).attr('data-prodid') == productID) {
                    $(this).parents('tr').remove();
                }
            });
            Tax = $('#ddlTax').val();
            AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.AddProduct(productID,Tax, OnSuccessAdded, OnFailure);
        }

        function OnSuccessAdded(result) {
            var NewRow = '<tr><td class="pos-tblName"><a class="anchor" onclick="OpenProduct(\'' + result.ProductID + '\')" data-prodid="' + result.ProductID + '">' + result.ProductName + '</a></td>'
                + '<td align="center" class="pos-tblQty">' + result.Quantity + '</td>' +
                '<td align="right" class="pos-tblPrice">' + parseFloat2(result.OrderPrice) + '</td>' +
                '<td align="right" class="pos-tblTotal">' + parseFloat2(result.Amount) + '</td>' +
                '<td align="center"><a class="fa fa-times-circle-o fa-2x" href="#" onclick="DeleteConfirmation(\'' + result.ProductID + '\');" /> </td></tr>';
            $('#ShoppingCartTable tbody').append(NewRow);
            UpdateShoppingCart();
            $('#imgloader').hide();
        }

        function UpdateShoppingCart() {
            //$('#loader').show();
            Tax = $('#ddlTax').val();
            AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.ReturnOrderDetails(Tax,OnSuccessUpdated, OnFailure);
        }

        function OnSuccessUpdated(result) {
            $('#lblNumberofItems').text(result.OrdersDetailsList.length);
            $('#lblSubTotal').text(parseFloat2(result.SubTotal));
            $('#lblDiscount').text(parseFloat2(result.Discount));
            $('#lblTotalBeforeGST').text(parseFloat2(result.TotalBeforeGST));
            $('#lblGST').text(parseFloat2(result.GST));
            $('#lblTotal').text(parseFloat2(result.Total));
            $('#lblTotalPayment').text('Pay SGD ' + parseFloat2(result.Total));
           
        }

        function DeleteConfirmation(productID) {

            $('#divConfirmation').modal({
                backdrop: 'static'
            });
            CurrentProduct = productID;
        }

        function ConfirmDelete() {
            $('#divConfirmation').modal('hide');
            $('#ShoppingCartTable tbody').find('td.pos-tblName a').each(function () {
                if ($(this).attr('data-prodid') == CurrentProduct) {
                    $(this).parents('tr').remove();
                }
            });
            $('#lblNumberofItems').text($('#ShoppingCartTable tbody tr').length);
            Tax = $('#ddlTax').val();
            AZVIC.Ei8htPOS.WebUI.Admin.WebService.AzvicService.DeleteProduct(CurrentProduct, Tax, OnSuccessDeleted, OnFailure);
        }

        function OnSuccessDeleted() {
            UpdateShoppingCart();
        }

        function OnFailure(error) {
            ShowAlert(error.message, 'Ei8ht POS');
        }


    </script>
</asp:Content>
